VERSION 5.00
Begin VB.Form frmSCU 
   Caption         =   "Commitment SCU"
   ClientHeight    =   9252
   ClientLeft      =   3912
   ClientTop       =   1116
   ClientWidth     =   9228
   LinkTopic       =   "Form1"
   ScaleHeight     =   9252
   ScaleWidth      =   9228
   Begin VB.TextBox Text1 
      Height          =   6975
      Left            =   120
      MultiLine       =   -1  'True
      TabIndex        =   2
      Top             =   2160
      Width           =   8895
   End
   Begin VB.Timer tmr_dicom_connection 
      Enabled         =   0   'False
      Interval        =   5000
      Left            =   4440
      Top             =   1440
   End
   Begin VB.CommandButton cmdStorageCommitment 
      Caption         =   "Send Storage Commitment Request"
      Height          =   495
      Left            =   1080
      TabIndex        =   0
      Top             =   1440
      Width           =   1935
   End
   Begin VB.Label Label1 
      Caption         =   $"Commitment SCU.frx":0000
      Height          =   1215
      Left            =   120
      TabIndex        =   1
      Top             =   0
      Width           =   9015
   End
End
Attribute VB_Name = "frmSCU"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
' ----------------------------------------------------------------------------------------------------------
' This Examples Handles the Storage Commitment Push Model SOP Class
' Using either the same or a different association for the response
' ----------------------------------------------------------------------------------------------------------

Private WithEvents m_ds As DicomServer
Attribute m_ds.VB_VarHelpID = -1
Private m_assoc As DicomConnection

Private Sub Form_Load()
    Set m_ds = New DicomServer
    m_ds.DefaultStatus = &H110
    m_ds.Listen 11112
End Sub

Private Sub cmdStorageCommitment_Click()

    ' Close possible previously open association, and create a new one.
    CloseOutgoing
    
    Set m_assoc = Nothing
    Set m_assoc = m_ds.New("DicomConnection")
    
    ' Enable timer to close association after a time-out
    tmr_dicom_connection.Enabled = True
    
    'Negoptiate a suitable association with correct SOP Class
    m_assoc.MetaSOPClass = doSOP_StorageCommitmentPush
    m_assoc.Contexts.Add doSOP_StorageCommitmentPush
    m_assoc.Contexts(1).RequestorSCURole = True
    m_assoc.Contexts(1).RequestorSCPRole = False
    m_assoc.Contexts(1).OfferedTS = "1.2.840.10008.1.2"
    m_assoc.SetDestination "localhost", 104, "SC_SCU", "SC_SCP"

    ' Other operations after SetDestination are fired by ActionComplete event
End Sub
Private Sub m_ds_ActionComplete(ByVal Connection As DicomObjects8.DicomConnection, ByVal Action As String, ByVal Tag As Variant, ByVal Success As Boolean, ByVal ErrorMessage As String)
    If Success Then
        If Action = "SetDestination" Then
        
            'First create the dataset to define the request
            Dim ds As New DicomDataSet, dss1 As New DicomDataSets, ds1 As DicomDataSet
            Dim ds2 As New DicomDataSet, dss2 As New DicomDataSets, g As New DicomGlobal
            
            ' these next 4 lines could be repated N times to send a request for N images
            Set ds1 = New DicomDataSet
            ds1.Attributes.Add 8, &H1150, "1.2.840.10008.5.1.4.1.1.7"
            ds1.Attributes.Add 8, &H1155, g.NewUID
            dss1.Add ds1
            
            ds.Attributes.Add 8, &H1199, dss1
            ds.Attributes.Add 8, &H1195, g.NewUID  ' Transaction UID
                  
            Log "Sending storage commitment request - Transaction UID= " & ds.Attributes(8, &H1195)
            
            'Send the commitment message
            Connection.NAction doSOP_StorageCommitmentPush, doInstance_StorageCommitmentPush, 1, ds
        ElseIf Action = "NAction" Then
            Log "Status received = " & Connection.LastStatus
        End If
    Else
        Log "ERROR after " & Action & " : " & ErrorMessage
    End If
End Sub

Private Sub m_ds_AssociationRequest2(ByVal Connection As DicomObjects8.DicomConnection, isOK As Boolean)
    Log "Incoming Association received"
End Sub

Private Sub m_ds_EventReport(ByVal Connection As DicomObjects8.DicomConnection, ByVal EventID As Integer, ByVal dataset As DicomObjects8.DicomDataSet, Status As Long)
    Dim ls_AffectedSOPInstanceUID As String
    Dim ls_CommandField As Long
    Dim ls_StudyInstanceUID As String
    Dim ls_EventTypeID As String
    Dim ll_status As Long
    Dim s_msg As String

    ll_status = &H110 ' Proccesing failure
    
    ls_CommandField = Connection.Command.Attributes.Item(&H0, &H100).Value
    
    If ls_CommandField <> &H100 Then Debug.Print "FATAL ERROR!!!"
    ls_AffectedSOPInstanceUID = Connection.Command.Attributes.Item(&H0, &H1000).Value
    ls_EventTypeID = Connection.Command.Attributes.Item(&H0, &H1002).Value
    If ls_AffectedSOPInstanceUID <> doInstance_StorageCommitmentPush Then
       '
       ' if AffectedSOPInstanceUID does not correspond to the well-known UID
        ' of the Storage Commitment Push Model SOP Instance, report an error
        ll_status = &H112 ' No such Object Instance
        Err.Raise vbObjectError + 10
    End If
    
    If m_assoc Is Nothing Then
        Log "Response received on different association"
    Else
        If m_assoc.Association = Connection.Association Then
            Log "Response received on original association"
        Else
            Log "Response received on different association"
        End If
    End If
      
    Select Case EventID
    
        Case "1"
            Log "Storage commitment succeeded for Transaction UID: " & dataset.Attributes(&H8, &H1195)
        Case "2"
            Log "Storage commitement failed for Transaction UID: " & dataset.Attributes(&H8, &H1195)
        Case Else
            '
            ' if Action Type ID not 1 or 2,  report an error
            ll_status = &H123 ' No such Action Type
            Err.Raise vbObjectError + 10
    End Select
    Status = &H0 ' success
End Sub

Private Sub tmr_dicom_connection_Timer()
    CloseOutgoing
End Sub

Sub Log(msg As String)
    Text1 = Text1 & msg & vbCrLf
End Sub

Sub CloseOutgoing()
    On Error GoTo er
    tmr_dicom_connection.Enabled = False
    m_assoc.Close
    Log "Outgoing Association Closed"
er:
    Set m_assoc = Nothing
End Sub
